Admin REST API for Event Rules
==============================

Overview
--------

### Log on

``` javascript
POST /admin/v1/authentication
```

### Get a list of sites

``` javascript
GET /admin/v2/sites
```

### Get a list of event rule folders

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rule-folders
```

### Add new event rule folder

``` javascript
POST /admin/v2/sites/{{Siteid}}/event-rule-folders
```

### Change an event rule folder

``` javascript
PATCH /admin/v2/sites/{{Siteid}}/event-rule-folders/{{evfolderid}}
```

### Get the details of one specific event rule folder

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rule-folders/{{evfolderid}}
```

### Delete one specific event rule folder

``` javascript
DELETE /admin/v2/sites/{{Siteid}}/event-rule-folders/{{evfolderid}}
```

### Get a list of event rules (not structured by folders)

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rules/
```

### Get the details of one specific event rule

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rules/af32b847-243a-485f-858a-156457fcd325
```

### Delete one specific event rule

``` javascript
DELETE /admin/v2/sites/{{Siteid}}/event-rules/af32b847-243a-485f-858a-156457fcd325
```

### Create event rule

``` javascript
POST /admin/v2/sites/{{Siteid}}/event-rules
```

### Change event rule

``` javascript
PATCH /admin/vv/sites/{{Siteid}}/event-rules/af32b847-243a-485f-858a-156457fcd325
```

Getting started
---------------

### Log on

Log on to the Admin rest interface. The admin rest interface is by
default on port 4450. This can be set in EFT Admin GUI on the
Administration tab.

``` javascript
POST /admin/v1/authentication
Content-Type: application/json

{"userName": "admin", "password": "mypassword", "authType": "EFT"}
```

The authentication endpoint will return and authToken, which will be
used with the future requests.

### Get site list

We need the list of sites to get further to the event rules

``` javascript
GET /admin/v2/sites
Authorization: EFTAdminAuthToken {{AuthToken}}
```

The request will return a json with a list of sites.

The site GUID will be used in the further requests.

Event Rule Folders
------------------

### Get a list of event rule folders

Replace {{Siteid}} with the GUID for the site:

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rule-folders
Authorization: EFTAdminAuthToken {{AuthToken}}
```

The request will give a list of event rule folders with name and id of
event rules inside. The root folder will show twice, once for regular
event rules, and once for remote event rules.

### Create a new event rule folder

``` javascript
POST /admin/v2/sites/{{Siteid}}/event-rule-folders
Authorization: EFTAdminAuthToken {{AuthToken}}

{"name":"my new folder","isRemote":false, "id":"{{evfolderid}}"}
```

JSON values used in request:

-   **name** (required): Name of the new folder. If the folder name
    already exists the request will fail.

-   **isRemote** (optional, defaulted to false): Specifies whether the
    folder is for remote event rules or not.

-   **Id** (optional): The GUID that will be used for the folder
    internally in EFT. If you don't specify it, EFT will create one. If
    the specified Id already exists, the request will fail.

If the POST is successful, the header of the response will contain a
Location item with the url of the new folder.

### Change name of event rule folder

Then name is the only part of an event rule folder that can be changed

``` javascript
PATCH /admin/v2/sites/{{Siteid}}/event-rule-folders/{{evfolderid}}
Authorization: EFTAdminAuthToken {{AuthToken}}

{"name":"My New Folder"}
```

### Get the settings of a single event rule folder

By specifying the event rule folder id, you will only get the
information about that event rule folder

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rule-folders/{{evfolderid}}
Authorization: EFTAdminAuthToken {{AuthToken}}
```

### Delete an event rule folder

``` javascript
DELETE /admin/v2/sites/{{Siteid}}/event-rule-folders/{{evfolderid}}
Authorization: EFTAdminAuthToken {{AuthToken}}
```

Delete will delete the event rule folder specified. If the folder has
event rules in it, the call will fail.

Event rules
-----------

### Get list of event rules

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rules/
Authorization: EFTAdminAuthToken {{AuthToken}}
```

The call will give a flat list of event rules, without the folder
structure. It will only show the GUID, name and folder id of each event
rule.

### Get single event rule

``` javascript
GET /admin/v2/sites/{{Siteid}}/event-rules/{{eventRuleID}}
Authorization: EFTAdminAuthToken {{AuthToken}}
```

By pointing to a specific event rule, you will get the full
specification of the event rule.

### Delete event rule

``` javascript
DELETE /admin/v2/sites/{{Siteid}}/event-rules/{{eventRuleID}}
Authorization: EFTAdminAuthToken {{AuthToken}}

{"comment":"Event rule not needed"}
```

Comment: any comment in the comment field will be added to the "Event
rule changes log". If no comment is given, the change log will only get
a default message.

Delete will delete a specific event rule.

### Create event rule

When you create a new event rule, you need to supply the whole event
rule specification.

``` javascript
POST /admin/v2/sites/{{Siteid}}/event-rules
Authorization: EFTAdminAuthToken {{AuthToken}}

{
  "data": {
    "type": "eventRule",
    "id": "a0537801-2d7a-4506-82ad-bfccf304e6b5",
    "attributes": {
      "comment": "new event rule",
      "info": {
      "Description": "Execute a specified action.",
      "Enabled": true,
      "Folder": "{{evfolderid}}",
      "Name": "myEventRule",
      "Next": "00000000-0000-0000-0000-000000000000",
      "Remote": false,
      "Type": "Timer"
      },
      "statements": {
      ...
      },
      "trigger": {
      ...
      }
    }
  }
}
```

JSON values used in request:

-   **comment** (optional): Creating a new event rule will create an
    entry in the "Event rules changes log". If comment is set, it will
    be part of this entry.

-   **Id** (optional): The GUID that will be used for the event rule
    internally in EFT. If you don't specify it, EFT will create one. If
    the specified Id already exists, the request will fail.

-   **name** (required): Name of the event rule seen in the user
    interface. If the event rule name already exists, the request will
    fail.

-   **next** (optional): This is used for internal sequence. If it is
    specified and is different from a null GUID
    (00000000-0000-0000-0000-000000000000), the GUID that it specifies,
    has to point to an existing event rule of the same type.

Post will add a new event rule. If it succeeds, the response header will
contain Location with the url of the new event rule.

### Change event rule

When changing an event rule, you have to specify the whole event rule
specification

``` javascript
PATCH /admin/v2/sites/{{Siteid}}/event-rules/a0537801-2d7a-4506-82ad-bfccf304e6b5
Authorization: EFTAdminAuthToken {{AuthToken}}

{
  "data": {
    "type": "eventRule",
    "id": "a0537801-2d7a-4506-82ad-bfccf304e6b5",
    "attributes": {
      "comment":"changing the name",
      "info": {
      "Description": "Backup and Cleanup2",
      "Enabled": true,
      "Folder": "00000000-0000-0000-0000-000000000000",
      "Name": "Backup and Cleanup3",
      "Next": "00000000-0000-0000-0000-000000000000",
      "Remote": false,
      "Type": "Timer"
      },
      "statements": {
      ...
      },
      "trigger": {
      ...
      }
    }
  }
}
```

Add a comment field if wanted, but apart from that, only change what
should be changed.

The request will change the event rule and add a comment in the "Event
rule changes log".
